/*

    Example: Functional ActionScript — Part III
    
    Author:
    Daniel Gasienica
    daniel@gasienica.ch
    http://gasi.ch/
    
    
    Originally published on
	http://gasi.ch/blog/functional-actionscript-part-3/
    
    Released under the
    Creative Commons Attribution-Share Alike License
    http://creativecommons.org/licenses/by-sa/3.0/
    
*/
package
{
	import flash.display.Sprite;
	
	
	public class FunctionalActionScript3 extends Sprite
	{
		private var unsortedList : Array = [ 23, 15, 16, 42, 8, 4 ]
		
		
		// Constructor
		public function FunctionalActionScript3()
		{
			// quick sort the functional way
			trace( "\n--- QuickSort ------------------------" )
			trace( 			    "unsorted:", unsortedList )
			trace( 			      "sorted:", quickSort( unsortedList ) )
		}
		

		// quick sort the functional way
		private function quickSort( list : Array ) : Array
		{
			// non-recursive branch
			if( list.length == 0 )
			{
				// return the empty array if we can't split it more
				return []				
			}
			else
			{
				// choose first element as pivot
				var pivot : Number = list[ 0 ]
				
				// slice of the pivot and keep them as rest
				var rest : Array = list.slice( 1 ) 
						
				return(
					// sort all numbers…
					quickSort(
						// …that are less or equal than pivot…
						rest.filter(
									  wrap( lessOrEqualThan( pivot ) )
									)
							 )
							 // …concatenate them with the pivot…							 
							 .concat(
							 		  [ pivot ]
									)
							 // …and concatenate all of the previous…
							 .concat(
					// …with all sorted numbers…							 
					quickSort(		 
						// …that are greater than pivot.
						rest.filter(
								  	  wrap( greaterThan( pivot ) ) 
								  	)
							 )
					    )
					)
					
/*					
			 // too much whitespace for your taste? try this… =) 
			 return(quickSort(rest.filter(wrap(lessOrEqualThan(pivot))))
			      .concat([pivot])
			.concat(quickSort(rest.filter(wrap(greaterThan(pivot))))))
*/
			}
		}
		
		// quicksort helper (higher order functions, meaning they return functions themselves)
		private function lessOrEqualThan( value : Number ) : Function
		{
			return(
					function( x : Number ) : Boolean
					{
						return x <= value
					}
				  )
		}
		
		private function greaterThan( value : Number ) : Function
		{
			return(
					function( x : Number ) : Boolean
					{
						return x > value
					}
				  )
		}
		
		
		/* 
			a beautiful example of a higher order function that takes a function
			as argument and then constructs and returns a new function:
			
			wrapper to make a function's signature conform to that of
			a valid callback which looks like this, e.g. for the filter function
			
				function callback(item:*, index:int, array:Array):Boolean;
			
			http://livedocs.adobe.com/flex/3/langref/Array.html#filter()
		*/
		private function wrap( f : Function ) : Function
		{
			return(
					function( x : *, index : int, array : Array ) : *
					{
						return f( x )
					}
				)
		}
	}
}